;=============================================================================
; Starship Mission List for PCC
; Format for each mission:    code,flags,name
;                               key=value
; * code = Mission Code
; * flags = set of the following:
;   +0-9ab      = only given races
;   -0-9ab      = except for given races
;   r           = registered only
;   *           = requires intercept argument (integer)
;   #           = requires tow argument (integer)
;   i           = "intercept" type mission (wrt. fleets etc)
;   p*, p#      = intercept/tow argument (planet id)
;   s*, s#      = intercept/tow argument (ship id)
;   h*, h#      = intercept/tow argument (ship id, ship must be here)
;   b*, b#      = intercept/tow argument (base id)
;   o[psh][*#]  = own ship/planet/here
;   ![sh][*#]   = don't allow this ship as argument
;   y*, y#      = intercept/tow argument (player #)
; * name = name of mission in [M] list. A letter prefixed with ~ is
;   the shortcut key. Default shortcut is mission number (if <=9) or a
;   still unused letter.
; * key=value pairs (indented in next lines)
;   s=name      short mission name (<=7 chars), default=first 7 chars of
;               long name
;   c=expr      condition saying when this mission is available
;   t=expr      text to display if mission is set, default=long name.
;               If it returns EMPTY, the default is used.
;   i=name      name of "I" parameter (<=7 chars)
;   j=name      name of "T" parameter (<=7 chars)
;
; PCC also supports MISSION.INI, the extended mission file from WinPlan.
; That one is not as configurable as MISSION.CC. Missions appear in the
; same order as here in PCC.
;
; Note that some of the standard missions have hard-wired additional
; actions: mine laying => shows size of new field, tow => computes
; additional engine load and displays tower's waypoint in towee's control
; screen
;=============================================================================

; If you want PCC to be able to name a mission, but not set it, use
; `c=False'. `none' is set by Host (and sometimes PCC) if it doesn't
; know better. You can't usually set this mission manually. Use
; `Explore' instead.
0,,none
                c = False

;==== Normal Missions ====
1,,Explore
2,,Mine Sweep
                s = M-Sweep
3,,Lay Mines
                c = Torp
4,,Kill
5,,Sensor Sweep
                s = Sensor
6,,Land & Disassemble
                s = L&D
7,!h#,Tow a ship
                t = "Towing " # ShipName(Mission.Tow)
                s = Tow
8,!is*,Intercept a ship
                t = "Intercepting " # ShipName(Mission.Intercept)
                s = Interc.

;==== Race Specific Missions ====
9,+1,Super Refit
                s = S-Refit
9,+2,Hisssssssss
                c = Beam
9,+3,Super Spy
                s = S-Spy
9,+4,Pillage Planet
9,+5,Rob ship
                c = Beam
                s = RobShip
9,+6,Self Repair
                s = Repair
9,+7,Lay Web Mines
                c = Torp
                s = LayWeb
9,+8,Dark Sense
                s = DkSense
9,+9b,Build Fighters
                c = Fighter.Bays
                s = B-Ftr
9,+a,Rebel Ground Attack
                s = RGA

;==== More Missions ====
10,,~Cloak
                c = InStr(Hull.Special, "C")
11,,Beam Up ~Fuel
                s = BU Fuel
12,,Beam Up ~Duranium
                s = BU Dur
13,,Beam Up ~Tritanium
                s = BU Tri
14,,Beam Up ~Molybdenum
                s = BU Mol
15,,Beam Up ~Supplies
                s = BU Supp

;=== PHost Extended Missions ===
; comment these out to save memory
; `Cloak', `Special' and `Beam up Multiple' have `c=False'. This
; prevents you from setting those missions manually; you shouldn't need
; to do it. `Cloak' and `Special' can be set the normal way, `Beam
; up Multiple' can be set using the normal cargo transfer screen.
; To set them anyway, use the MIT interface and enter the mission
; number by hand. And don't forget to tell me why you needed to do this
; so I can include that rule in PCC.
20,,Build Torpedoes from Cargo
                s = B-Torps
                c = System.Host$=2 AND Torp
21,*y#,Lay Minefield
                t = "Lay " # Z(Mission.Intercept) # " mines"
                c = System.Host$=2 AND Torp
                i = Torps
                j = Player
22,*y#+7,Lay Web Mines
                t = "Lay " # Z(Mission.Intercept) # " web mines"
                c = System.Host$=2 AND Torp
                i = Torps
                j = Player
23,*#,Scoop Torpedoes
                t = "Scoop " & Mission.Intercept & " torps" & (" from field #" # Z(Mission.Tow))
                s = Scoop T
                c = System.Host$=2 AND Torp
                i = Torps
                j = Mine Id
24,*,Gather-Build Torpedoes
                t = "Gather-Build " # Z(Mission.Intercept) # " torps"
                s = GB-Torp
                c = System.Host$=2 AND Torp
25,*,Beam down Credits
                t = "Beam down " # Z(Mission.Intercept) # " mc"
                s = BD mc
                c = System.Host$=2
26,#!h*,Transfer Torpedoes
                t = "Transfer " # Mission.Tow # " torps to " # ShipName(Mission.Intercept)
                s = XferTor
                c = System.Host$=2 AND Torp
                i = Target
                j = Amount
27,#!h*,Transfer Fighters
                t = "Transfer " # Mission.Tow # " fighters to " # ShipName(Mission.Intercept)
                s = XferFtr
                c = System.Host$=2 AND Fighter.Bays
                i = Target
                j = Amount
28,#!h*,Transfer Money
                t = "Transfer " # Mission.Tow # " mc to " # ShipName(Mission.Intercept)
                s = Xfer mc
                c = System.Host$=2
                i = Target
                j = Amount
29,+3,Standard Super Spy
                s = Std Spy
                c = System.Host$=2
30,,Cloak
                c = False
31,,Special
                c = False
32,*+9ab,Gather-Build Fighters
                t = "Gather-Build " # Z(Mission.Intercept) # " fighters"
                s = GB-Ftrs
                c = System.Host$=2 AND Fighter.Bays
33,*,Beam Up Credits
                t = "Beam up " # Z(Mission.Intercept) # " mc"
                s = BU mc
                c = System.Host$=2
34,*,Beam Up Clans
                t = "Beam up " # Z(Mission.Intercept) # " clans"
                s = BU Clan
                c = System.Host$=2
35,,Beam Up Multiple
                s = BU many
                c = False
36,*#,Add Mines to Field
                t = "Add " & If(Mission.Intercept, Mission.Intercept, "all") & " torps" & (" to minefield #" # Mission.Tow)
                s = MinesIn
                c = System.Host$=2 AND Torp
                i = Amount
                j = Mine Id
37,*#+7,Add Web Mines to Field
                t = "Add " & If(Mission.Intercept, Mission.Intercept, "all") & " torps to web #" # Mission.Tow
                s = Web In
                c = System.Host$=2 AND Torp
                i = Amount
                j = Mine Id

100,b*,Mission which takes a starbase arg
101,p*,Mission which takes a planet arg
102,op*,Mission which takes an own planet
103,s*,Mission which takes a ship
104,!s*,Mission which takes not this ship
105,os*,Mission which takes own ship
106,!os*,Mission which takes own, not this, ship
107,h*,Mission which takes ship here
108,!h*,Mission which takes ship here not this
109,oh*,Mission which takes own ship here
110,!oh*,Mission which takes own not this here
111,y*,Mission which takes player
112,!y*,Mission which takes player but not me
