/**
  *  \file util/translation.hpp
  *  \brief Translation
  *
  *  Translation occurs by having a Translator object translate strings.
  *
  *  Previously, this file hosted a `_` macro to perform translation (like in PCC2).
  *  This has been replaced by
  *  - explicitly passing the Translator to the component needing it
  *  - in rare cases, using afl::string::Translator::getSystemInstance() directly
  *  The latter shall be avoided because it's using global state,
  *  but cannot always be avoided; in particular, because it's used for error messages generated by afl.
  *
  *  To find strings needing to be translated, we're looking for token sequences consisting of
  *  - a function name
  *  - zero or one `()`
  *  - a parenized string `("foo")`
  *
  *  The function name can be
  *  - `tx` (local variable)
  *  - `m_translator` (member variable)
  *  - `translator` (member function)
  *  - `translateString` (explicit invocation of function; obsolescent/being phased out)
  *  - `N_` (explicitly marked; see macro in this file)
  *  - `Translate` (CCScript function)
  *  - `_` (shortcut in CCScript; previously also macro in this file)
  */
#ifndef C2NG_UTIL_TRANSLATION_HPP
#define C2NG_UTIL_TRANSLATION_HPP

/** Mark a string for translation.
    The string will be recognized as needing translation, but will not yet be translated.
    User needs to invoke the translator on it later on. */
#define N_(x) (x)

#endif
