/**
  *  \file test/server/format/truehullpackertest.cpp
  *  \brief Test for server::format::TruehullPacker
  */

#include "server/format/truehullpacker.hpp"

#include "afl/charset/utf8charset.hpp"
#include "afl/data/access.hpp"
#include "afl/data/value.hpp"
#include "afl/test/testrunner.hpp"
#include <memory>

/** Test regular truehull file. */
AFL_TEST("server.format.TruehullPacker:normal", a)
{
    static const uint8_t TRUEHULL[] = {
        0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00,
        0x11, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0d, 0x00, 0x07, 0x00, 0x0b, 0x00, 0x0c, 0x00, 0x13, 0x00,
        0x68, 0x00, 0x12, 0x00, 0x14, 0x00, 0x69, 0x00, 0x0f, 0x00, 0x18, 0x00, 0x0e, 0x00, 0x10, 0x00,
        0x15, 0x00, 0x16, 0x00, 0x08, 0x00, 0x04, 0x00, 0x11, 0x00, 0x19, 0x00, 0x07, 0x00, 0x31, 0x00,
        0x68, 0x00, 0x12, 0x00, 0x17, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x1b, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x1a, 0x00, 0x20, 0x00, 0x3b, 0x00, 0x1c, 0x00,
        0x30, 0x00, 0x11, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x1f, 0x00, 0x2f, 0x00, 0x68, 0x00, 0x12, 0x00,
        0x1d, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x22, 0x00, 0x28, 0x00, 0x0e, 0x00,
        0x10, 0x00, 0x24, 0x00, 0x3b, 0x00, 0x25, 0x00, 0x26, 0x00, 0x11, 0x00, 0x1e, 0x00, 0x21, 0x00,
        0x27, 0x00, 0x29, 0x00, 0x68, 0x00, 0x12, 0x00, 0x23, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x01, 0x00, 0x2c, 0x00, 0x22, 0x00, 0x28, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x2b, 0x00,
        0x2d, 0x00, 0x3b, 0x00, 0x2a, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x26, 0x00, 0x11, 0x00, 0x2f, 0x00,
        0x68, 0x00, 0x12, 0x00, 0x32, 0x00, 0x69, 0x00, 0x33, 0x00, 0x0f, 0x00, 0x39, 0x00, 0x55, 0x00,
        0x36, 0x00, 0x10, 0x00, 0x37, 0x00, 0x3a, 0x00, 0x11, 0x00, 0x38, 0x00, 0x34, 0x00, 0x68, 0x00,
        0x12, 0x00, 0x35, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x42, 0x00, 0x10, 0x00, 0x0e, 0x00, 0x3c, 0x00, 0x41, 0x00, 0x3b, 0x00, 0x3e, 0x00,
        0x11, 0x00, 0x3d, 0x00, 0x40, 0x00, 0x3f, 0x00, 0x68, 0x00, 0x12, 0x00, 0x43, 0x00, 0x69, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x47, 0x00, 0x49, 0x00, 0x4d, 0x00,
        0x48, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x44, 0x00, 0x4b, 0x00, 0x4c, 0x00, 0x11, 0x00, 0x45, 0x00,
        0x4a, 0x00, 0x68, 0x00, 0x12, 0x00, 0x46, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x51, 0x00, 0x55, 0x00, 0x10, 0x00, 0x52, 0x00, 0x54, 0x00, 0x53, 0x00, 0x11, 0x00,
        0x4e, 0x00, 0x50, 0x00, 0x68, 0x00, 0x12, 0x00, 0x4f, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x62, 0x00, 0x67, 0x00, 0x57, 0x00,
        0x0e, 0x00, 0x10, 0x00, 0x5b, 0x00, 0x58, 0x00, 0x5d, 0x00, 0x5a, 0x00, 0x64, 0x00, 0x11, 0x00,
        0x56, 0x00, 0x5c, 0x00, 0x65, 0x00, 0x59, 0x00, 0x68, 0x00, 0x12, 0x00, 0x5e, 0x00, 0x69, 0x00,
        0x0f, 0x00, 0x62, 0x00, 0x67, 0x00, 0x5f, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x60, 0x00, 0x61, 0x00,
        0x64, 0x00, 0x2a, 0x00, 0x11, 0x00, 0x56, 0x00, 0x5c, 0x00, 0x65, 0x00, 0x66, 0x00, 0x59, 0x00,
        0x68, 0x00, 0x12, 0x00, 0x63, 0x00, 0x69, 0x00
    };

    // Decode
    afl::charset::Utf8Charset cs;
    server::format::TruehullPacker testee;
    std::auto_ptr<afl::data::Value> p(testee.unpack(afl::string::fromBytes(TRUEHULL), cs));
    afl::data::Access ap(p);

    // Verify data format
    a.checkEqual("01. getArraySize", ap.getArraySize(), 11U);
    for (size_t i = 0; i < 11U; ++i) {
        a.checkEqual("02", ap[i].getArraySize(), 20U);
    }

    // Verify some hulls
    a.checkEqual("11", ap[0][0].toInteger(), 1);
    a.checkEqual("12", ap[1][0].toInteger(), 15);
    a.checkEqual("13", ap[2][0].toInteger(), 15);
    a.checkEqual("14", ap[5][0].toInteger(), 51);
    a.checkEqual("15", ap[5][14].toInteger(), 105);
    a.checkEqual("16", ap[5][19].toInteger(), 0);
    a.checkEqual("17", ap[10][0].toInteger(), 15);
    a.checkEqual("18", ap[10][19].toInteger(), 105);

    // Re-pack
    String_t repacked = testee.pack(p.get(), cs);
    a.checkEqual("21", repacked, afl::string::fromBytes(TRUEHULL));
}

/** Test too-small file. */
AFL_TEST("server.format.TruehullPacker:small", a)
{
    // Truehull is only decoded completely.
    // A too-short file is not decoded at all.
    afl::charset::Utf8Charset cs;
    server::format::TruehullPacker testee;
    std::auto_ptr<afl::data::Value> p(testee.unpack(String_t(439, ' '), cs));
    afl::data::Access ap(p);
    a.checkEqual("01. getArraySize", ap.getArraySize(), 0U);
}
