/**
  *  \file test/game/db/loadertest.cpp
  *  \brief Test for game::db::Loader
  */

#include "game/db/loader.hpp"

#include "afl/charset/codepage.hpp"
#include "afl/charset/codepagecharset.hpp"
#include "afl/io/constmemorystream.hpp"
#include "afl/io/internalstream.hpp"
#include "afl/io/nullfilesystem.hpp"
#include "afl/string/nulltranslator.hpp"
#include "afl/sys/log.hpp"
#include "afl/test/testrunner.hpp"
#include "game/parser/messageinformation.hpp"
#include "game/parser/messagevalue.hpp"
#include "game/test/defaultshiplist.hpp"
#include "interpreter/values.hpp"

using game::PlayerSet_t;
using game::map::Drawing;
using game::map::DrawingContainer;
using game::map::Minefield;
using game::map::Point;
using game::map::Ufo;
using game::parser::MessageInformation;
using interpreter::World;

namespace {
    /* Titan 12, player 7, turn 7 [file written by PCC 2.0.7] */
    const uint8_t FILE_DATA[] = {
        0x43, 0x43, 0x63, 0x68, 0x61, 0x72, 0x74, 0x1a, 0x07, 0x00, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00,
        0x07, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x54, 0x07, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x54,
        0x05, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x02, 0x09, 0xc7, 0x05, 0xb0, 0x05, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xff, 0xff, 0x03, 0x09, 0xf9, 0x04, 0x11, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x70, 0x17, 0x00, 0x00, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03,
        0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03,
        0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a,
        0x03, 0x02, 0xe8, 0x03, 0xe8, 0x03, 0xe8, 0x03, 0x14, 0x00, 0x05, 0x0a, 0x03, 0x02, 0x01, 0x00,
        0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x31, 0x35, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x9a, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x02, 0x00,
        0x00, 0xf0, 0x07, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x7f, 0x02, 0x00, 0x00, 0x21, 0x00, 0x0b,
        0x00, 0x4a, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07,
        0x00, 0x00, 0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x07, 0x00, 0xa8, 0x00, 0x5c, 0x54, 0x43, 0x01,
        0x00, 0x0c, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xdf, 0x03, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0xb6, 0x05, 0x00, 0x00, 0x66, 0x01, 0x00,
        0x00, 0x60, 0x00, 0x28, 0x00, 0x44, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x64,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07,
        0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x08, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x00,
        0x00, 0x04, 0x11, 0x11, 0x11, 0x11, 0x21, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x73, 0x69, 0x6f, 0x6e,
        0x20, 0x54, 0x36, 0x20, 0x28, 0x43, 0x6f, 0x6c, 0x6f, 0x2d, 0x46, 0x72, 0x61, 0x63, 0x68, 0x74,
        0x65, 0x72, 0x29, 0x20, 0x7c, 0x54, 0x3a, 0x36, 0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x07, 0x00,
        0x51, 0x01, 0x45, 0x6e, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x52,
        0x00, 0x00, 0x00, 0x56, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf9, 0x06, 0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0x98,
        0x16, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x30, 0x00, 0x32, 0x00, 0x3e, 0x00, 0x3f, 0x00, 0x00,
        0x00, 0x01, 0x00, 0x64, 0x00, 0x64, 0x00, 0x03, 0x00, 0x57, 0x7c, 0x00, 0x00, 0x01, 0x00, 0x15,
        0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x08, 0x00, 0x1c, 0x00,
        0x00, 0x00, 0x51, 0x01, 0x01, 0x00, 0x00, 0x04, 0x11, 0x11, 0x11, 0x11, 0x11, 0x48, 0x75, 0x6d,
        0x20, 0x44, 0x6d, 0x20, 0x6e, 0x65, 0x65, 0x64, 0x43, 0x20, 0x7c, 0x54, 0x3a, 0x37, 0x01, 0x00,
        0x5e, 0x00, 0x00, 0x00, 0x07, 0x00, 0x83, 0x01, 0x26, 0x6d, 0x4b, 0xc8, 0x00, 0xfa, 0x00, 0x64,
        0x00, 0x1c, 0x07, 0x00, 0x00, 0x4b, 0x01, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x5e, 0x01, 0x00,
        0x00, 0x23, 0x85, 0x00, 0x00, 0x46, 0x05, 0x00, 0x00, 0x1b, 0x0b, 0x00, 0x00, 0x6d, 0x26, 0x00,
        0x00, 0x2d, 0x07, 0x00, 0x00, 0x32, 0x0d, 0x00, 0x00, 0x6c, 0x03, 0x00, 0x00, 0x14, 0x00, 0x14,
        0x00, 0x0f, 0x00, 0x5f, 0x00, 0x07, 0x00, 0x00, 0x00, 0x5d, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07,
        0x00, 0x00, 0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe9, 0x01, 0x34, 0x37, 0x33, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00,
        0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x0f, 0x00, 0x00, 0x00, 0xbb, 0x01, 0x00, 0x00, 0x12, 0x02, 0x00, 0x00, 0xa8, 0x09, 0x00,
        0x00, 0x31, 0x00, 0x46, 0x00, 0x21, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x64,
        0x00, 0x07, 0x00, 0xd4, 0x80, 0x00, 0x00, 0x07, 0x00, 0x23, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07,
        0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x08, 0x00, 0x15, 0x00, 0x00, 0x00, 0xe9, 0x01, 0x01, 0x00,
        0x00, 0x04, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x41, 0x6d, 0x70, 0x20, 0x4d, 0x20, 0x7c, 0x54, 0x3a,
        0x37, 0x02, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x76, 0x48, 0x79, 0x07, 0x00,
        0x18, 0x00, 0xd7, 0xff, 0xa6, 0x05, 0x4b, 0x05, 0x06, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x1e, 0x00, 0x41, 0x7a, 0x75, 0x72, 0x69, 0x74, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x60, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x64, 0x00, 0x07, 0x00, 0x07, 0x00, 0x03, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00,
        0xa6, 0x05, 0x4b, 0x05, 0x05, 0x95, 0x00, 0x74, 0x00, 0xaa, 0x05, 0x51, 0x05, 0x02, 0xce, 0x00,
        0x79, 0x00, 0x9c, 0x05, 0x92, 0x05, 0x08, 0xa7, 0x00, 0xa1, 0x00, 0xc7, 0x05, 0xb0, 0x05, 0x07,
        0xeb, 0x00, 0xc8, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x6f, 0x00, 0x00, 0x00,
        0x0c, 0x00, 0x01, 0x00, 0xff, 0xff, 0xff, 0x08, 0x00, 0x00, 0x80, 0x00, 0x80, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0x02, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x4f, 0x43,
        0x54, 0x55, 0x52, 0x4e, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x44, 0x45, 0x53, 0x54,
        0x52, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x03,
        0x00, 0x5e, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x06, 0x00, 0xf9, 0x04, 0x11, 0x06, 0x08, 0xb4, 0x00,
        0x06, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0x07, 0x00, 0x16, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x01, 0x00, 0x00, 0x04, 0x11,
        0x11, 0x11, 0x11, 0x0b, 0x46, 0x65, 0x64, 0x20, 0x54, 0x36, 0x20, 0x7c, 0x54, 0x3a, 0x36, 0x02,
        0x00, 0x6f, 0x00, 0x00, 0x00, 0x12, 0x00, 0x07, 0x00, 0x42, 0x4d, 0x2f, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xc7, 0x05, 0xb0, 0x05, 0x06, 0x00, 0x42, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x07, 0x00, 0x13, 0x00, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00,
        0x00, 0x00, 0x53, 0x61, 0x70, 0x70, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x65, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x07, 0x00, 0x07, 0x00, 0x03, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x07, 0x00, 0xc7, 0x05,
        0xb0, 0x05, 0x00, 0xff, 0xff, 0x94, 0x00, 0xc7, 0x05, 0xb0, 0x05, 0x00, 0xff, 0xff, 0x94, 0x00,
        0xc7, 0x05, 0xb0, 0x05, 0x00, 0xff, 0xff, 0x94, 0x00, 0xc7, 0x05, 0xb0, 0x05, 0x00, 0xff, 0xff,
        0x94, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x51, 0x00,
        0x07, 0x00, 0x2a, 0x4b, 0x66, 0x08, 0x00, 0xdf, 0xff, 0x2a, 0x00, 0x62, 0x05, 0xc8, 0x05, 0x09,
        0x00, 0x3c, 0x00, 0x07, 0x00, 0x04, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x50, 0x00, 0x53, 0x70, 0x65, 0x63, 0x74,
        0x72, 0x6f, 0x6c, 0x69, 0x74, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x14, 0x00, 0x0a, 0x00, 0xe9, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x07, 0x00, 0x07, 0x00, 0x03, 0x00, 0x5e,
        0x00, 0x00, 0x00, 0x51, 0x00, 0x07, 0x00, 0x62, 0x05, 0xc8, 0x05, 0x08, 0x41, 0x01, 0x72, 0x01,
        0x9c, 0x05, 0x92, 0x05, 0x09, 0x38, 0x01, 0xb0, 0x01, 0xc7, 0x05, 0xb0, 0x05, 0x07, 0xeb, 0x00,
        0xc6, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0x02, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x19, 0x01, 0x07, 0x00, 0x6e, 0x78, 0x49, 0x09, 0x00,
        0xc8, 0xff, 0x34, 0x00, 0x9c, 0x05, 0x92, 0x05, 0x09, 0x00, 0x3c, 0x00, 0x07, 0x00, 0x04, 0x00,
        0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x88, 0x00, 0xa0, 0x00, 0x54, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x74, 0x65, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x04, 0x01, 0x07, 0x00, 0x07, 0x00, 0x03, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x19, 0x01, 0x07, 0x00,
        0x9c, 0x05, 0x92, 0x05, 0x09, 0x38, 0x01, 0xc6, 0x01, 0xc7, 0x05, 0xb0, 0x05, 0x07, 0xeb, 0x00,
        0xf8, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x6f, 0x00, 0x00, 0x00,
        0x1a, 0x01, 0x07, 0x00, 0x32, 0x79, 0x26, 0x07, 0x00, 0xd7, 0xff, 0xe4, 0xff, 0xc7, 0x05, 0xb0,
        0x05, 0x09, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x58, 0x02, 0x50, 0x65, 0x7a,
        0x7a, 0x6f, 0x74, 0x74, 0x61, 0x69, 0x74, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x07, 0x00, 0x07, 0x00, 0x03,
        0x00, 0x5e, 0x00, 0x00, 0x00, 0x1a, 0x01, 0x07, 0x00, 0xc7, 0x05, 0xb0, 0x05, 0x07, 0xeb, 0x00,
        0xc0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff
    };

    struct Environment {
        afl::charset::CodepageCharset cs;
        afl::sys::Log log;
        afl::io::NullFileSystem fs;
        afl::string::NullTranslator tx;
        World world;
        game::spec::ShipList sl;
        game::config::HostConfiguration config;
        game::Game g;
        game::Turn t;

        Environment(int turnNr, int nShips, int nPlanets)
            : cs(afl::charset::g_codepage437),
              log(), fs(), tx(),
              world(log, tx, fs),
              sl(), config(), g(), t()
            {
                game::test::initDefaultShipList(sl);
                t.setTurnNumber(turnNr);
                for (int i = 1; i <= nShips; ++i) {
                    t.universe().ships().create(i);
                }
                for (int i = 1; i <= nPlanets; ++i) {
                    t.universe().planets().create(i);
                }
            }
    };
}


/** Test loading a prepared file. */
AFL_TEST("game.db.Loader:prepared", a)
{
    Environment env(7, 900, 500);
    for (int i = 1; i <= 500; ++i) {
        game::map::Planet* pl = env.t.universe().planets().create(i);
        pl->setAutobuildGoal(game::FactoryBuilding, 0);          // reset to prove that the loader sets these
        pl->setAutobuildSpeed(game::FactoryBuilding, 1);
    }

    // Loader
    game::db::Loader testee(env.cs, env.world, env.tx);

    // Load
    afl::io::ConstMemoryStream inputStream(FILE_DATA);
    testee.load(inputStream, env.t, env.g, true);

    // Must postprocess to set types
    env.t.universe().postprocess(PlayerSet_t(20), PlayerSet_t(20), game::map::Object::ReadOnly,
                                 env.g.mapConfiguration(), game::HostVersion(), env.config, 7, env.sl, env.tx, env.log);

    // Verify
    // - autobuild
    {
        a.checkEqual("01. getAutobuildGoal",  env.t.universe().planets().get(100)->getAutobuildGoal(game::FactoryBuilding), 1000);
        a.checkEqual("02. getAutobuildSpeed", env.t.universe().planets().get(100)->getAutobuildSpeed(game::FactoryBuilding), 10);
    }

    // - drawing
    {
        const DrawingContainer& dc = env.t.universe().drawings();

        // A circle
        DrawingContainer::Iterator_t it1 = dc.findNearestVisibleDrawing(Point(1466, 1466), env.g.mapConfiguration(), 100, afl::base::Nothing);
        a.check("11. findNearestVisibleDrawing", it1 != dc.end());
        a.checkEqual("12. getPos", (**it1).getPos(), Point(1479, 1456));
        a.checkEqual("13. getCircleRadius", (**it1).getCircleRadius(), 10);
        a.checkEqual("14. getColor", (**it1).getColor(), 9);

        // A marker
        DrawingContainer::Iterator_t it2 = dc.findMarkerAt(Point(1273, 1553), afl::base::Nothing);
        a.check("21. findMarkerAt", it2 != dc.end());
        a.checkEqual("22. getMarkerKind", (**it2).getMarkerKind(), 2);
        a.checkEqual("23. getColor", (**it2).getColor(), 9);
    }

    // - planet history
    {
        const game::map::Planet* pl = env.t.universe().planets().get(96);
        a.checkNonNull("31. planet", pl);
        a.checkEqual("32. getFriendlyCode", pl->getFriendlyCode().orElse(""), "157");

        int owner = -1;
        a.checkEqual("41. getOwner", pl->getOwner().get(owner), true);
        a.checkEqual("42. owner", owner, 0);
        a.checkEqual("43. neu", pl->getCargo(game::Element::Neutronium).orElse(-1), 154);
        a.checkEqual("44. getTemperature", pl->getTemperature().orElse(-1), 40);
    }
    {
        const game::map::Planet* pl = env.t.universe().planets().get(168);
        a.checkNonNull("45. planet", pl);
        a.checkEqual("46. getFriendlyCode", pl->getFriendlyCode().orElse(""), "\\TC");
        int owner = -1;
        a.checkEqual("47. getOwner", pl->getOwner().get(owner), true);
        a.checkEqual("48. owner", owner, 7);
        a.checkEqual("49. neu", pl->getCargo(game::Element::Neutronium).orElse(-1), 119);
        a.checkEqual("50. getTemperature", pl->getTemperature().orElse(-1), 23);
    }

    // - planet property
    {
        afl::data::NameMap::Index_t idx = env.world.planetPropertyNames().getIndexByName("COMMENT");
        a.checkEqual("51. getIndexByName", idx, World::pp_Comment);
        afl::data::Value* p = env.world.planetProperties().get(489, idx);
        a.checkNonNull("52. value", p);
        a.checkEqual("53. toString", interpreter::toString(p, false), "Amp M |T:7");
    }

    // - ship track
    {
        const game::map::Ship* sh = env.t.universe().ships().get(7);
        a.checkNonNull("61. ship", sh);

        const game::map::ShipHistoryData::Track* t6 = sh->getHistoryLocation(6);
        a.checkNonNull("71. getHistoryLocation", t6);
        a.checkEqual("72. x",       t6->x.orElse(-1), 1450);
        a.checkEqual("73. y",       t6->y.orElse(-1), 1361);
        a.checkEqual("74. mass",    t6->mass.orElse(-1), 121);
        a.checkEqual("75. heading", t6->heading.orElse(-1), 206);
        a.checkEqual("76. speed",   t6->speed.orElse(-1), 2);

        const game::map::ShipHistoryData::Track* t3 = sh->getHistoryLocation(3);
        a.checkNonNull("81. getHistoryLocation", t3);
        a.check("82. x",       !t3->x.isValid());
        a.check("83. y",       !t3->y.isValid());
        a.check("84. mass",    !t3->mass.isValid());
        a.check("85. heading", !t3->heading.isValid());
        a.check("86. speed",   !t3->speed.isValid());
    }

    // - ship history
    {
        const game::map::Ship* sh = env.t.universe().ships().get(81);
        a.checkNonNull("91. ship", sh);

        int owner = -1;
        a.check("101. getOwner", sh->getOwner().get(owner));
        a.checkEqual("102. owner", owner, 7);
        a.checkEqual("103. getFriendlyCode", sh->getFriendlyCode().orElse(""), "*Kf");
        a.checkEqual("104. getEngineType", sh->getEngineType().orElse(-1), 9);
        a.checkEqual("105. neu", sh->getCargo(game::Element::Neutronium).orElse(-1), 96);
        a.checkEqual("106. getHistoryTimestamp", sh->getHistoryTimestamp(game::map::Ship::MilitaryTime), 7);
    }

    // - ship property
    {
        afl::data::NameMap::Index_t idx = env.world.shipPropertyNames().getIndexByName("COMMENT");
        a.checkEqual("111. getIndexByName", idx, World::sp_Comment);
        afl::data::Value* p = env.world.shipProperties().get(12, idx);
        a.checkNonNull("112. value", p);
        a.checkEqual("113. toString", interpreter::toString(p, false), "Fed T6 |T:6");
    }

    // Test save. For now, we cannot check for 1:1 correspondence.
    // Known differences:
    // - we write LongString format, which is one byte shorter than the classic ShortString format
    // - we clear unknown data more aggressively
    // Therefore, test for close proximity; this should detect if an object goes missing accidentally.

    // Save
    afl::io::InternalStream out;
    testee.save(out, env.t, env.g, env.sl);

    // Verify
    a.check("121. file size", out.getSize() >= sizeof(FILE_DATA) - 10);
    a.check("122. file size", out.getSize() <= sizeof(FILE_DATA) + 10);
}

/** Test save/load roundtrip. */
AFL_TEST("game.db.Loader:roundtrip", a)
{
    afl::io::InternalStream stream;

    // Create a file exercising all properties
    {
        Environment env(10, 100, 100);

        // Drawing with tag (rPaintingTags, rPainting)
        {
            std::auto_ptr<Drawing> d(new Drawing(Point(1200, 1400), Drawing::MarkerDrawing));
            d->setColor(5);
            d->setMarkerKind(2);
            d->setTag(env.world.atomTable().getAtomFromString("a marker"));
            d->setComment("a comment");
            env.t.universe().drawings().addNew(d.release());
        }

        // Minefield (rMinefield)
        {
            MessageInformation info(MessageInformation::Minefield, 140, 10);
            info.addValue(game::parser::mi_X, 900);
            info.addValue(game::parser::mi_Y, 800);
            info.addValue(game::parser::mi_Radius, 30);
            info.addValue(game::parser::mi_Owner, 10);
            env.t.universe().minefields().addMessageInformation(info);
        }

        // Autobuild (rAutoBuild)
        env.t.universe().planets().get(10)->setAutobuildGoal(game::MineBuilding, 42);

        // Planet (rPlanetHistory)
        env.t.universe().planets().get(20)->setOwner(3);

        // Ship (rShipHistory, rShipTrack)
        env.t.universe().ships().get(50)->addShipXYData(Point(3000, 2000), 3, 200, PlayerSet_t(1));
        env.t.universe().ships().get(50)->setHull(30);

        // Properties (rPlanetProperty, rShipProperty)
        env.world.shipProperties().create(5)->setNew(World::sp_Comment, interpreter::makeStringValue("ship comment"));
        env.world.planetProperties().create(15)->setNew(World::pp_Comment, interpreter::makeStringValue("planet comment"));

        // Planet scores (rPlanetScore)
        {
            game::UnitScoreDefinitionList::Definition def;
            def.name = "Planet Exp";
            def.id = game::ScoreId_ExpLevel;
            def.limit = 5;

            game::UnitScoreDefinitionList::Index_t idx = env.g.planetScores().add(def);
            env.t.universe().planets().get(23)->unitScores().set(idx, 3, 10);
        }

        // Ship scores (rShipScore)
        {
            game::UnitScoreDefinitionList::Definition def;
            def.name = "Ship Exp";
            def.id = game::ScoreId_ExpLevel;
            def.limit = 5;

            game::UnitScoreDefinitionList::Index_t idx = env.g.shipScores().add(def);
            env.t.universe().ships().get(42)->unitScores().set(idx, 4, 10);
        }

        // Ufos
        {
            Ufo* u = env.t.universe().ufos().addUfo(444, 10, 2);
            u->setIsStoredInHistory(true);
            u->setName("Flying Saucer");
            u->setPosition(Point(1700, 1300));
            u->setRadius(20);
        }

        // Postprocess to set finish
        env.t.universe().postprocess(PlayerSet_t(20), PlayerSet_t(20), game::map::Object::ReadOnly,
                                     env.g.mapConfiguration(), game::HostVersion(), env.config, 10, env.sl, env.tx, env.log);

        // Save
        game::db::Loader(env.cs, env.world, env.tx).save(stream, env.t, env.g, env.sl);
    }

    // Load that file again
    {
        Environment env(10, 100, 100);

        stream.setPos(0);
        game::db::Loader(env.cs, env.world, env.tx).load(stream, env.t, env.g, true);

        // Verify
        // Drawing with tag (rPaintingTags, rPainting)
        {
            a.check("01. drawing", env.t.universe().drawings().begin() != env.t.universe().drawings().end());

            Drawing* d = *env.t.universe().drawings().begin();
            a.checkNonNull("02. drawing", d);
            a.checkEqual  ("03. type",    d->getType(), Drawing::MarkerDrawing);
            a.checkEqual  ("04. color",   d->getColor(), 5);
            a.checkEqual  ("05. tag",     env.world.atomTable().getStringFromAtom(d->getTag()), "a marker");
            a.checkEqual  ("06. comment", d->getComment(), "a comment");
        }

        // Minefield (rMinefield)
        {
            Minefield* mf = env.t.universe().minefields().get(140);
            a.checkNonNull("11. minefield", mf);
            a.checkEqual("12. pos", mf->getPosition().orElse(Point()), Point(900, 800));
        }

        // Autobuild (rAutoBuild)
        a.checkEqual("21. autobuild", env.t.universe().planets().get(10)->getAutobuildGoal(game::MineBuilding), 42);

        // Planet (rPlanetHistory)
        a.checkEqual("31. planet owner", env.t.universe().planets().get(20)->getOwner().orElse(-1), 3);

        // Ship (rShipHistory, rShipTrack)
        a.checkEqual("41. ship owner", env.t.universe().ships().get(50)->getOwner().orElse(-1), 3);
        a.checkEqual("42. ship hull",  env.t.universe().ships().get(50)->getHull().orElse(-1), 30);

        // Properties (rPlanetProperty, rShipProperty)
        a.checkEqual("51. ship comment",   interpreter::toString(env.world.shipProperties().create(5)->get(World::sp_Comment), false), "ship comment");
        a.checkEqual("52. planet comment", interpreter::toString(env.world.planetProperties().create(15)->get(World::pp_Comment), false), "planet comment");

        // Unit scores (rPlanetScore, rShipScore)
        a.checkEqual("61. planet exp", env.t.universe().planets().get(23)->unitScores().getScoreById(game::ScoreId_ExpLevel, env.g.planetScores()).orElse(-1), 3);
        a.checkEqual("62. ship exp",   env.t.universe().ships().get(42)->unitScores().getScoreById(game::ScoreId_ExpLevel, env.g.planetScores()).orElse(-1), 4);

        // Ufos
        {
            Ufo* u = env.t.universe().ufos().getUfoByIndex(env.t.universe().ufos().findUfoIndexById(444));
            a.checkNonNull("71. ufo", u);
            a.checkEqual("72. name",   u->getName(), "Flying Saucer");
            a.checkEqual("73. radius", u->getRadius().orElse(-1), 20);
        }
    }
}

/** Test loading a broken file. */
AFL_TEST("game.db.Loader:error:broken", a)
{
    Environment env(7, 900, 500);

    // Loader
    game::db::Loader testee(env.cs, env.world, env.tx);

    // Load: this still succeeds
    afl::io::ConstMemoryStream inputStream(afl::base::Nothing);
    AFL_CHECK_SUCCEEDS(a, testee.load(inputStream, env.t, env.g, true));
}
