start('c2untrn', 'Turn File Decompiler and Manipulator');

section('Synopsis',
        paragraph_synopsis('<b>c2untrn</b> [<b>-h</b>|<b>-v</b>]'),
        paragraph_synopsis('<b>c2untrn</b> [<b>-</b>pPtTsckr] [<b>-d</b>] [<b>-C</b> <i>CSET</i>] [<b>-f</b> <i>EXPR</i>] [<b>-e</b> <i>CMD</i>] <i>playerX.trn</i>'));

section('Description',
        paragraph_text('<i>c2untrn</i> is a program that can display and manipulate the contents of TRN files.',
                       'This can be used to track down cheat reports,',
                       'analyze the behaviour of client programs,',
                       'and to sanitize turn files which PHost rejects or which crash host.exe.'),
        paragraph_text('This version of <i>c2untrn</i> is part of the PCC2 program suite.',
                       '<i>c2untrn</i> originally was a DOS program coded in pretty unportable Turbo Pascal code.',
                       'In previous versions (not c2ng), it was called <i>un-trn</i>.'),
        paragraph_text('A turn file starts with a <i>header</i> which contains administrative information, in particular, the timestamp.',
                       'The header is followed by a sequence of <i>commands</i>, which represent the broken-down actions of the player.',
                       'For example, selling a supply is encoded as a change to the amount of money and to the amount of supplies on the planet.',
                       'Finally, the turn ends with a <i>trailer</i> which contains checksums and registration information.',
                       'Turn files may contain <i>attachments</i>, which are only supported by host.exe.',
                       'This feature is used by Taccom.'),
        paragraph_text('The most basic operation is to decode a single turn file:'),
        paragraph_indent('c2untrn <i>file.trn</i>'),
        paragraph_text('Options can be added anywhere on the command line.',
                       'Note that for options that take an argument, there must be a space between the option and the argument.'));

section('Options',
        paragraph_default_help(';'),
        paragraph_detail(text_option('-v'),
                         paragraph_text('Show <i>version</i> number;')),
        paragraph_detail(text_option('-p'),
                         paragraph_text('Display turn header (<i>prefix</i>). This is the default if no filter is used;')),
        paragraph_detail(text_option('-P'),
                         paragraph_text('Do not display turn header. This is the default if a filter is used;')),
        paragraph_detail(text_option('-t'),
                         paragraph_text('Display turn <i>trailer</i>. This is the default if no filter is used;')),
        paragraph_detail(text_option('-T'),
                         paragraph_text('Do not display turn trailer. This is the default if a filter is used;')),
        paragraph_detail(text_option('-f', 'EXPR'),
                         paragraph_text('<i>Filter</i> turn file commands (see below);')),
        paragraph_detail(text_option('-e', 'CMD'),
                         paragraph_text('<i>Edit</i> basic turn parameters (see below). Can appear several times;')),
        paragraph_detail(text_option('-C', 'CSET'),
                         paragraph_text('Specify <i>character set</i> used in the game.',
                                        'This affects decoding of messages and names;')),
        paragraph_detail(text_option('-c'),
                         paragraph_text('Do not show most <i>comments</i>.',
                                        'This is useful if you want to compare output of two <i>c2untrn</i> runs.',
                                        'Comments contain file offsets, which would most likely cause many false negatives during comparison.')),
        paragraph_text('The following options modify the turn before anything else is done.',
                       'If you specify <b>-r</b>, the changes produced by these actions are written back to disk.'),
        paragraph_detail(text_option('-s'),
                         paragraph_text('<i>Sort</i> turn before doing anything else;')),
        paragraph_detail(text_option('-a'),
                         paragraph_text('Ignore Taccom <i>attachments</i>;')),
        paragraph_detail(text_option('-z'),
                         paragraph_text('Delete all turn contents (<i>zap</i>!). Only the turn header and trailer bearing the',
                                        'timestamp and registration information will be left intact.')));

subsect('Actions',
        paragraph_text('By default, <i>c2untrn</i> lists the TRN file contents to standard output.',
                       'The following options select an alternative mode of operation.',
                       'Only one of them may be specified.'),
        paragraph_detail(text_option('-r'),
                         paragraph_text('<i>Rewrite</i> turn.',
                                        "If PHost doesn't understand a turn file, this will most likely fix it.",
                                        '<b>-r</b> alone will make no other changes to the turn,',
                                        'but changes implied by other options will be performed;')),
        paragraph_detail(text_option('-d'),
                         paragraph_text('<i>Delete</i> all commands that match filter (ignores <b>-pPtT</b>,',
                                        'implies <b>-r</b>, requires that you specify a filter using <b>-f</b>).',
                                        'This will re-write the turn; it will not make a backup copy;')),
        paragraph_detail(text_option('-n'),
                         paragraph_text('<i>No</i> output (ignores <b>-pPtT</b>).',
                                        'This effectively only checks the turn for syntactic correctness.')));

section('Filter Expressions',
        paragraph_text('Filter expressions are case-insensitive. When using Delete mode (<b>-d</b>),',
                       'the filter specifies the commands to delete; when using List mode (default),',
                       'it specifies the commands to list. Otherwise, it is ignored.'),
        paragraph_text('The following lists the syntax rules used to build filter expressions.',
                       'Note that you may have to quote the expression to prevent your shell',
                       'from interpreting operators such as "|" itself.'),

        paragraph_table('llll',
                        ['expression', ':=', 'summand',                ''],
                        ['',           ' |', 'summand "|" expression', 'Logical "or"'],
                        0,
                        ['summand',    ':=', 'factor',                 ''],
                        ['',           ' |', 'factor "&amp;" summand', 'Logical "and"'],
                        0,
                        ['factor',     ':=', '"!" factor',             'Negation'],
                        ['',           ' |', 'op-seq',                 ''],
                        0,
                        ['op-seq',     ':=', 'operand',                ''],
                        ['',           ' |', 'operand op-seq',         'Logical "and"'],
                        0,
                        ['operand',    ':=', '"(" expression ")"',     'Grouping'],
                        ['',           ' |', 'word',                   'Match command'],
                        ['',           ' |', 'word "*"',               'Match prefix'],
                        ['',           ' |', 'number',                 'Match Id'],
                        ['',           ' |', 'number "-" number',      'Match Id range'],
                        ['',           ' |', '"#" number',             'Match Nth command'],
                        ['',           ' |', '"#" number "-" number',  'Match command range'],
                        ['',           ' |', "\"'...'\"",              'Match fcode, message, name'],
                        ['',           ' |', '""...""',                'Match fcode, message, name'],
                        ['',           ' |', '"True"',                 'Match everything'],
                        ['',           ' |', '"False"',                'Match nothing']));

subsect('Filter Examples',
        paragraph_detail('Ship',
                         paragraph_text('(<i>Match prefix</i>) Match all ship commands;')),
        paragraph_detail('Ship* | Planet*',
                         paragraph_text('(<i>Logical or</i>) Matches ship and planet commands (i.e. any command that is a ship command or a planet command);')),
        paragraph_detail('Ship* &amp; 3',
                         paragraph_text('(<i>Logical and</i>) Matches commands for ship 3 (i.e. any command that is a ship command and has Id 3);')),
        paragraph_detail('! Ship*',
                         paragraph_text('(<i>Negation</i>) Matches all non-ship commands;')),
        paragraph_detail('Ship*3',
                         paragraph_text('(<i>Logical and</i>) Same as "<i>Ship* &amp; 3</i>", two operands without intervening operator are <i>and</i>ed;')),
        paragraph_detail('ShipChangeSpeed',
                         paragraph_text('(<i>Match command</i>) Match all ship speed changes.')),
        paragraph_detail('#5',
                         paragraph_text('(<i>Match Nth command</i>) Match fifth command in the turn file.')),
        paragraph_detail("'NTP'",
                         paragraph_text('(<i>Match fcode, message, name</i>) Match all friendly code changes, name',
                                        'changes, or messages containing "NTP". Case is ignored;')),
        paragraph_detail('Ship*(3|15|42)',
                         paragraph_text('(<i>Grouping</i>) Match all commands for ships 3, 15 and 42.')));

section('Examples');

subsect('Deleting Commands (-d)',
        paragraph_text('When the option <i>-d</i> is used, <i>c2untrn</i> will delete commands instead of displaying them.',
                       'The turn file will be re-written (without backup!).',
                       'This option requires a filter to be used (matching commands will be deleted).'),
        paragraph_text("For example, when you know that the source of the red alert you're experiencing",
                       'is caused by commands on planet 3,'),
        paragraph_indent('c2untrn player7.trn -df Planet*3'),
        paragraph_text('will fix the problem',
                       '(note that usually things are not that easy, the error might also be caused by ships orbiting planet 3.)'));

subsect('Rewriting the turn (-r)',
        paragraph_text('With the <i>-r</i> option, <i>un-trn</i> will not display anything',
                       'and just re-write the turn in a valid file format.',
                       'When PHost does not understand a turn file ("Turn damaged"),',
                       'this option might fix it',
                       "(some unconventional Maketurns generate turn files that don't follow the",
                       'specs by 100% but are still accepted by THost).'),
        paragraph_text('This should not change the meaning of the turn',
                       '(in particular, the registration information and Taccom attachments will remain there).',
                       'The only change is that after <i>c2untrn -r</i>, <i>c2untrn</i> will report',
                       'the file as being written by PCC2. Which is actually is, of course :)'),
        paragraph_text('If you do not use Taccom, it makes sense to run <i>c2untrn -rsa</i> on all',
                       'Turn files before hosting. This will rewrite turns in a sound format,',
                       "and close certain security holes in THost's Taccom turn file parser."));

section('Editing',
        paragraph_text('You can change basic parameters of TRN files using <b>-e</b>.',
                       'That option expects a parameter of the form <i>COMMAND=VALUE</i>.',
                       'Commands are case-insensitive.',
                       '<i>c2untrn</i> accepts the following commands:',
                       '(Note that these commands are not actual turn file commands.',
                       'There is currently no way to add commands to a turn file.)',
                       'Editing commands are case-insensitive.'),
        paragraph_detail('<b>-e time=</b><i>MM-DD-YYYYHH:MM:SS</i>',
                         paragraph_text('Set the timestamp of the turn. You can use this to make a turn fit',
                                        'the host timestamp after a host re-run. <i>c2untrn</i> does not enforce the',
                                        'syntactic form of the timestamp.')),
        paragraph_detail('<b>-e version=</b><i>NN</i>',
                         paragraph_text('Set the version of the turn. This only applies to Winplan-style',
                                        'turns. It changes the built-in version stamp to "3.5<i>NN</i>". Currently',
                                        'circulating maketurns generate 3.500 or 3.501 turns; as far as I',
                                        'can tell, no host differentiates here yet.')));

section('Output Format',
        paragraph_text('The important contents of the turn, header, commands and trailer,',
                       'are shown as a series of assignments (<i>name = value</i>).',
                       'TRN commands start with the command word followed by several assignments.',
                       'String values are quoted in a C-like fashion.'),
        paragraph_text('Comments (<i>; text</i>) contain additional useful information,',
                       'for example, file positions, notes on checksums and on the file format.',
                       'Comments can be turned off using <i>-c</i>.'));

subsect('Command Names',
        paragraph_table('ll',
                        ['BaseBuildEngines',      'BaseBuildFighters'],
                        ['BaseBuildHulls',        'BaseBuildLaunchers'],
                        ['BaseBuildShip',         'BaseBuildTorpedoes'],
                        ['BaseBuildWeapons',      'BaseChangeDefense'],
                        ['BaseChangeMission',     'BaseFixRecycleShip'],
                        ['BaseFixRecycleShipId',  'BaseUpgradeEngineTech'],
                        ['BaseUpgradeHullTech',   'BaseUpgradeTorpTech'],
                        ['BaseUpgradeWeaponTech', 'ChangePassword'],
                        ['PlanetBuildBase',       'PlanetChangeColonists'],
                        ['PlanetChangeDefense',   'PlanetChangeDuranium'],
                        ['PlanetChangeFactories', 'PlanetChangeFc'],
                        ['PlanetChangeMines',     'PlanetChangeMolybdenum'],
                        ['PlanetChangeMoney',     'PlanetChangeNeutronium'],
                        ['PlanetChangeSupplies',  'PlanetChangeTritanium'],
                        ['PlanetColonistTax',     'PlanetNativeTax'],
                        ['SendBack',              'SendMessage'],
                        ['ShipBeamDownCargo',     'ShipChangeColonists'],
                        ['ShipChangeDuranium',    'ShipChangeFc'],
                        ['ShipChangeMission',     'ShipChangeMolybdenum'],
                        ['ShipChangeMoney',       'ShipChangeName'],
                        ['ShipChangeNeutronium',  'ShipChangePrimaryEnemy'],
                        ['ShipChangeSpeed',       'ShipChangeSupplies'],
                        ['ShipChangeTorpedoes',   'ShipChangeTritanium'],
                        ['ShipChangeWaypoint',    'ShipIntercept'],
                        ['ShipTowShip',           'ShipTransferCargo']));

section('Exit Code',
        paragraph_detail('0', paragraph_text('Everything ok;')),
        paragraph_detail('1', paragraph_text("Error (can't open turn file, invalid file format, bogus command line);")),
        paragraph_detail('2', paragraph_text("The specified filter didn't match anything.")));

section('Environment',
        paragraph_default_environment());

section('Author',
        paragraph_default_author());

section('See Also',
        paragraph_link_list('pcc2(6)', 'c2mkturn(6)'));
